<?php
namespace VM\ApiBundle\Services;

use Symfony\Component\DependencyInjection\Container;
use Doctrine\ORM\EntityManager;
use Symfony\Component\HttpFoundation\Request;
//use Diagnostic\AdminBundle\Services\CodeService;
use VM\ApiBundle\Entity\User;
use VM\ApiBundle\Security\WebService\PasswordEncoder;
use VM\ApiBundle\Services\SSOMethods;
use VM\ApiBundle\VMApiBundle;

class UserManager
{
    /**
     * @var EntityManager
     */
    protected $EntityManager;

    /**
     * @var Request
     */
    protected $Request;

    /**
     * @var Container
     */
    protected $Container;


    public function __construct(Container $Container)
    {
        $this->EntityManager = $Container->get('doctrine.orm.default_entity_manager');
        $this->Container = $Container;
    }

    public function createUser($username, $userDataFromLoginSso = null)
    {
        $User = $this->getUserByUsername($username);
        if(empty($User))
        {
            $User = new User();
            $now = new \DateTime();

            if(is_null($userDataFromLoginSso))
            {
                $userData = array(
                    'user_id' => null,
                    'email' => $username,
                    'name' => '',
                    'surname' => '',
                    'last_login' => null,
                );
            }
            else
            {
                $userData = $this->getUserDataFromSso($userDataFromLoginSso);
                $User->setInternalUser(true);
                $User->setExternalId($userDataFromLoginSso['user_id']);
            }

            $User->setUsername($username);
            $User->setEmail($userData['email']);
            $User->setLastLogin($now);
            $User->setRoles($userDataFromLoginSso['roles']);
            $User->setName($userData['name']);
            $User->setSurname($userData['surname']);
            $User->setVisitsCount(0);

            $this->EntityManager->persist($User);
            $this->EntityManager->flush();

            $this->setRegistrationLog($User);
        }

        return $User;
    }

    protected function setRegistrationLog(User $User)
    {
//        $LogManager = $this->Container->get('vm.log.manager');
//        $LogManager->createLog(($fromNEDatabase) ? 'REGISTRATION_FROM_NE' : 'REGISTRATION_FROM_PAGE', $User);
//        $this->EntityManager->flush();
    }

    public function getUserByUsername($username)
    {
        return $this->EntityManager->getRepository('VM\ApiBundle\Entity\User')->findOneByUsername($username);
    }

    public function recoveryPassword(User $User)
    {
        $email = $User->getEmail();

        $hash = hash('sha512', $email);
        $randomStart = rand(1, 30);

        $password = substr($hash, $randomStart, 10);

        $this->setUserPassword($User, $password);

        return $password;
    }

    public function setUserPassword(USer $User, $password)
    {
        $PasswordEncoder = new PasswordEncoder();
        $salt = $PasswordEncoder->generateSalt($User->getEmail() . rand(1, 1000000));
        $encodedPassword = $PasswordEncoder->encodePassword($password, $salt);

        $User->setPassword($encodedPassword);
        $User->setSalt($salt);

        return $User;
    }

    public function getUserDataFromSso($userDataFromSso)
    {
        $ssoMethods = $this->Container->get('sso.methods');

        $params = array(
            'user_id' => $userDataFromSso['user_id'],
            'token' => $userDataFromSso['token']
        );

        $ssoMethods->setOptions('user_get',$params);

        return $ssoMethods->getResponse();
    }
}